 ; Ŀ
 ;   Diaper: search and replace layer names.                               
 ;   Copyright 1998, 2001 by Rocket Software Ltd.                          
 ;   Good for cleaning up crappy drawings.                                 
 ;                                                                         
 ;   Contains utilities:                                                   
 ;   Bloot: print all layer table data.                                    
 ;   Lance: convert all layer names to upper or lower case.                
 ; 

 ; Ŀ
 ;   Bloot: an invisible utility: print layer table data.                  
 ; 
 (DEFUN C:BLOOT (/ rew dat)
  (setq rew T)
  (while (setq dat (tblnext "layer" rew))
         (if dat (print dat))
         (setq rew ()))
  (princ))
 ; Ŀ
 ;   Bloot end.                                                            
 ; 

 ; Ŀ
 ;   Lance - utility - convert all layer names to upper or lower case.     
 ; 
 (DEFUN C:LANCE (/ uplor rew llist lanam gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Ask which way to go.                                                  
 ; 
  (initget 0 "Upper Lower")
  (setq uplor (getkword "Upper or <Lowercase>: "))
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lanam (cdr (setq asoc2 (assoc 2 llist))))
         (if (= uplor "Upper")
             (setq gnunam (strcase lanam))
             (setq gnunam (strcase lanam t)))
         (command ".rename" "layer" lanam gnunam))
 (princ))
 ; Ŀ
 ;   Lance end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Diaper.                                                               
 ; 
 (DEFUN C:DIAPER (/ oldstr newstr cas rew lanam chugs gnunam)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq oldstr (getstring "Old string: "))
  (setq newstr (getstring "New string: "))
  (initget 0 "Yes No")
  (setq cas (getkword "Case Sensitive Yes/<No>: "))
 ; Ŀ
 ;   Step through the layer tables and impart rationality.                 
 ; 
  (setq rew t)
  (while (setq llist (tblnext "layer" rew))
         (setq rew ())
         (setq lanam (cdr (assoc 2 llist)))
         (if (= cas "Yes")
             (setq chugs (chug oldstr newstr lanam))
             (setq chugs (chug (strcase oldstr) newstr (strcase lanam))))
         (if (and (/= lanam "0") (< 0 (cadr chugs)))
             (progn
                  (setq gnunam (car chugs))
                  (command ".rename" "layer" lanam gnunam))))
 (princ))

(princ)